# Generate SQL Deltas
# Copyright 2008 by Brian C. Christensen

# 080613 - start first draft
# 081118 - improve handling of changed columns
# 081125 - drop/add fk, index, check

##import ORM
##import math

debug = 1

##server = 'MS Access'
server = 'MS SQL Server'
##server = 'DB2'
##server = 'Oracle'
##server == 'MySQL'

new_version_suffix = "_changed"

def GenerateDeltas(project):

    text = []
    def printx(line):
        text.append(line)

    printx('''
This delta is generated as a starting point for data conversion.
Do not use as is. Be sure to review and alter it as necessary for
your particular circumstances.

---- Adds and alters to migrate database from baseline to current ----
''')

##    # drop all checks
##    checks = project.GetList('RelationalCheck')
##    checks.sort(cmp=lambda x,y: cmp(x.ID, y.ID))
##    for check in checks:
##        if check.InBase and check.BaseRelationalTable:
##            printx("alter table %s drop constraint %s;" %
##                   (check.BaseRelationalTable.Name, check.BaseName))
##    printx("")

    # drop all indices
    indices = project.GetList('RelationalIndex')
    indices.sort(cmp=lambda x,y: cmp(x.ID, y.ID))
    for index in indices:
        if index.InBase and index.BaseRelationalTable:
            table_name = index.BaseRelationalTable.BaseName
            index_name = index.BaseName
            # drop syntax from http://www.w3schools.com/SQL/sql_drop.asp
            if server == 'MS Access':
                printx("drop index %s on %s;" %
                       (index_name, table_name))
            elif server == 'MS SQL Server':
                printx("drop index %s.%s;" %
                       (table_name, index_name))
            elif server in ('DB2', 'Oracle'):
                printx("drop index %s;" % column_name)
            elif server == 'MySQL':
                printx("alter table %s " % table_name)
                printx("  drop index %s;" % index_name)
    printx("")
    
    tables = project.GetList('RelationalTable')
    tables.sort(cmp=lambda x,y: cmp(x.Name, y.Name))

    # drop all foreign key relationships
    for table in tables:
        if table.InBase:
            columns = table.GetList('RelationalColumn')
            columns.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))
            for column in columns:
                if column.InBase and column.BaseRelationalReference:
                    # drop syntax from http://www.w3schools.com/SQL/sql_foreignkey.asp
                    if server == 'MySQL':
                        printx("alter table %s " % table.BaseName)
                        printx("  drop constraint fk_%d;" % column.ID)
                    elif server in ('MS SQL Server', 'Oracle', 'MS Access'):
                        printx("alter table %s " % table.BaseName)
                        printx("  drop foreign key fk_%d;" % column.ID)
                    else: #  ??'DB2'
                        pass
    printx("")

    for table in tables:
        if table.InUse and not table.InBase:
            printx("create table %s (" % table.Name)
            columns = table.GetList('RelationalColumn')
            for column in columns:
                if column.InUse:
                    printx("  %s  %s  %s," % (
                        column.Name or "",
                        column.DataType or "",
                        column.Key or "",  # was PrimaryKey
                        ))
            printx(");")
        elif table.InUse:  # generate table alter adds
            columns = table.GetList('RelationalColumn')
            for column in columns:
                if column.InUse and not column.InBase:
                    printx("alter table %s (" % table.Name)
                    printx("  add column  %s  %s  %s," % (
                        column.Name or "",
                        column.DataType or "",
                        column.Key or "",
                        ))
                    printx(");")
                # should handle simple column renames here
                # Note: this should also handle know compatible changes
                #  that don't require a manual conversion
                # (such as making a varchar column wider)
                elif column.InUse and column.InBase and (
                      column.Name != column.BaseName and
                      column.DataType == column.BaseDataType and
                      column.Key == column.BaseKey):
                    printx("alter table %s (" % table.Name)
                    printx("  alter column  %s  %s  %s  %s," % (
                        column.BaseName or "",
                        column.Name or "",
                        column.DataType or "",
                        column.Key or "",
                        ))
                    printx(");")
                # changed columns are created here with new name
                # and then renamed after dropping old names in the next section
                elif column.InUse and column.InBase and (
                      column.Name != column.BaseName or
                      column.DataType != column.BaseDataType or
                      column.Key != column.BaseKey):
                    printx("alter table %s (" % table.Name)
                    printx("  add column  %s  %s  %s," % (
                        (column.Name or "") + new_version_suffix,
                        column.DataType or "",
                        column.Key or "",
                        ))
                    printx(");")

    printx('''
---- End of adds and alters ----

Beware. Be sure to convert and backup date before deleting tables and columns.
Do not use the following without making required modifications.

---- Beginning of drops ----
''')

    for table in tables:
        if not table.InUse and table.InBase:
            printx("drop table %s; " % table.BaseName)
        elif table.InUse:  # generate table alter adds
            columns = table.GetList('RelationalColumn')
            for column in columns:
                if not column.InUse and column.InBase:
                    printx("alter table %s" % table.Name)
                    printx("  drop column  %s;" % (
                        column.BaseName or "",
                        ))
                # simple renames have already been processed
                elif column.InUse and column.InBase and (
                      column.Name != column.BaseName and
                      column.DataType == column.BaseDataType and
                      column.Key == column.BaseKey):
                    pass
                # drop old version of changed columns; correct name of new version
                elif column.InUse and column.InBase and (
                      column.Name != column.BaseName or
                      column.DataType != column.BaseDataType or
                      column.Key != column.BaseKey):
                    # maybe change to put these in the same alter?
                    printx("alter table %s" % table.Name)
                    printx("  drop column  %s;" % (
                        column.BaseName or "",
                        ))
                    printx("alter table %s (" % table.Name)
                    printx("  alter column  %s  %s  %s  %s," % (
                        (column.Name or "") + new_version_suffix,
                        (column.Name or ""),
                        column.DataType or "",
                        column.Key or "",
                        ))
                    printx(");")

    printx("")
    # foreign key relationships (identical to Generate SQL script)
    for table in tables:
        if table.InUse:
            columns = table.GetList('RelationalColumn')
            columns.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))
            for column in columns:
                if column.InUse and column.RelationalReference:
                    printx("alter table %s " % table.Name)
                    printx("  add constraint fk_%d foreign key (%s) references  %s (%s)" % (
                        column.ID,  # to generate a key name
                        column.Name or "",
                        column.RelationalReference.RelationalTable.Name or "",
                        column.RelationalReference.Name or "",  # or comma separated names
                        ))
                    printx(";")

    printx("")
    # table indices (identical to Ganerate SQL script)
    indices = project.GetList('RelationalIndex')
    indices.sort(cmp=lambda x,y: cmp(x.ID, y.ID))
    for index in indices:
        if index.InUse:
            columns = index.GetList('RelationalIndexColumn')
            columns.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))
            names = [ c.RelationalColumn.Name for c in columns
                      if c.InUse and c.RelationalColumn ]
            printx("create %s index %s on %s with (%s);" %
                   (index.Unique or '', index.Name, index.RelationalTable.Name, ','.join(names)))

##    printx("")
##    # table checks (identical to Ganerate SQL script)
##    checks = project.GetList('RelationalCheck')
##    checks.sort(cmp=lambda x,y: cmp(x.ID, y.ID))
##    for check in checks:
##        if check.InUse:
##            printx("alter table %s add constraint %s check (" %
##                   (check.RelationalTable.Name, check.Name))
##            printx("%s" % (check.Check))
##            printx(");")

    printx('''
---- End of drops ----

End of SQL Deltas
''')
    return "\n".join(text)

def Do(self):
    rid = self.ReportID  # current report
    if rid == 1 :
        Data.Hint('Not for use in main report')
        return  # do nothing

    db = Data.DBObject  # will get objects from this database
    report = db.GetObject('Report',rid)

    text = GenerateDeltas( report.Project )

    dlg = wx.lib.dialogs.ScrolledMessageDialog(Data.OpenReports[1], text, "Generate SQL Deltas")
    dlg.Show()

##    Data.SetUndo('Baseline Rmap')

Do(self)

